/*
 * Translate column names into column indices
 */

#include "libfma.h"
#include "lf_internal.h"
#include "lf_db.h"

/*
 * Given a "column descriptor array" get column indices for each column label
 */
int
lf_get_column_indices(
  db_table_ptr_t tp,
  struct lf_col_desc *cdp,
  int ncols,
  int *colid,
  char *name)
{
  int rc;
  int c;

  /* get the column indices */
  for (c=0; c<ncols; ++c) {
    db_datum_type_t type;

    rc = db_get_column_info(tp, cdp[c].col_name,
                            &colid[c], &type);

    /* If column missing or wrong type, mark it gone */
    if (rc == -1 || type != cdp[c].col_type) {
      colid[c] = -1;
    }
  }
  return 0;
}

